

<?php $__env->startSection('title', 'Reports & Analytics'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <h1 class="text-3xl font-bold text-gray-800">Reports & Analytics</h1>
        <p class="text-gray-600 mt-2">Comprehensive insights and statistics for your telehealth system</p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <!-- Prescriptions Report -->
        <a href="<?php echo e(route('admin.reports.prescriptions')); ?>" class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-shadow p-6 border-l-4 border-blue-500">
            <div class="flex items-center justify-between">
                <div>
                    <div class="flex items-center mb-2">
                        <i class="fas fa-prescription text-blue-600 text-2xl mr-3"></i>
                        <h3 class="text-xl font-bold text-gray-800">Prescriptions Report</h3>
                    </div>
                    <p class="text-gray-600 text-sm">View prescription statistics, trends, and analytics</p>
                </div>
                <i class="fas fa-chevron-right text-gray-400"></i>
            </div>
        </a>

        <!-- Doctors Report -->
        <a href="<?php echo e(route('admin.reports.doctors')); ?>" class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-shadow p-6 border-l-4 border-green-500">
            <div class="flex items-center justify-between">
                <div>
                    <div class="flex items-center mb-2">
                        <i class="fas fa-user-md text-green-600 text-2xl mr-3"></i>
                        <h3 class="text-xl font-bold text-gray-800">Doctors Report</h3>
                    </div>
                    <p class="text-gray-600 text-sm">Doctor registration trends and statistics</p>
                </div>
                <i class="fas fa-chevron-right text-gray-400"></i>
            </div>
        </a>

        <!-- Patients Report -->
        <a href="<?php echo e(route('admin.reports.patients')); ?>" class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-shadow p-6 border-l-4 border-purple-500">
            <div class="flex items-center justify-between">
                <div>
                    <div class="flex items-center mb-2">
                        <i class="fas fa-users text-purple-600 text-2xl mr-3"></i>
                        <h3 class="text-xl font-bold text-gray-800">Patients Report</h3>
                    </div>
                    <p class="text-gray-600 text-sm">Patient demographics and registration data</p>
                </div>
                <i class="fas fa-chevron-right text-gray-400"></i>
            </div>
        </a>

        <!-- Appointments Report -->
        <a href="<?php echo e(route('admin.reports.appointments')); ?>" class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-shadow p-6 border-l-4 border-teal-500">
            <div class="flex items-center justify-between">
                <div>
                    <div class="flex items-center mb-2">
                        <i class="fas fa-calendar-check text-teal-600 text-2xl mr-3"></i>
                        <h3 class="text-xl font-bold text-gray-800">Appointments Report</h3>
                    </div>
                    <p class="text-gray-600 text-sm">Appointment statistics and trends</p>
                </div>
                <i class="fas fa-chevron-right text-gray-400"></i>
            </div>
        </a>

        <!-- Overview Dashboard -->
        <a href="<?php echo e(route('admin.reports.overview')); ?>" class="bg-white rounded-lg shadow-lg hover:shadow-xl transition-shadow p-6 border-l-4 border-indigo-500">
            <div class="flex items-center justify-between">
                <div>
                    <div class="flex items-center mb-2">
                        <i class="fas fa-chart-line text-indigo-600 text-2xl mr-3"></i>
                        <h3 class="text-xl font-bold text-gray-800">Overview Dashboard</h3>
                    </div>
                    <p class="text-gray-600 text-sm">Complete system overview and analytics</p>
                </div>
                <i class="fas fa-chevron-right text-gray-400"></i>
            </div>
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/admin/reports/index.blade.php ENDPATH**/ ?>